
// FSDIndexerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FSDIndexer.h"
#include "FSDIndexerDlg.h"
#include "options.h"
#include "http.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

ConnHand ch;

// CAboutDlg dialog used for App About
void ProcessMessages()
{
CWinApp* pApp = AfxGetApp();
MSG msg;

  while ( PeekMessage ( &msg, NULL, 0, 0, PM_NOREMOVE ))
      pApp->PumpMessage();
}

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CFSDIndexerDlg dialog




CFSDIndexerDlg::CFSDIndexerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFSDIndexerDlg::IDD, pParent)
	, m_ShowOnlyIncomplete(0)
{
	items = NULL;
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFSDIndexerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, m_GameList);
	DDX_Control(pDX, IDC_EDIT4, GameTitle);
	DDX_Control(pDX, IDC_EDIT5, m_Desc);
	DDX_Control(pDX, IDC_EDIT2, m_Genres);
	DDX_Control(pDX, IDC_EDIT3, m_Manuf);
	DDX_Control(pDX, IDC_EDIT6, m_Path);
	DDX_Control(pDX, IDC_CHECK1, m_HasIcon);
	DDX_Control(pDX, IDC_CHECK2, m_HasBoxart);
	DDX_Control(pDX, IDC_EDIT1, m_Screenshots);
	DDX_Control(pDX, IDC_LIST2, m_SSList);
	DDX_Control(pDX, IDC_EDIT7, m_AltUrl);
	DDX_Control(pDX, IDC_EDIT8, m_TitleID);
	DDX_Control(pDX, IDC_EDIT9, m_Version);
	DDX_Control(pDX, IDC_EDIT10, m_Disc);
	DDX_Radio(pDX, IDC_RADIO1, m_ShowOnlyIncomplete);
	DDX_Control(pDX, IDC_COMBO2, m_Type);
	DDX_Control(pDX, IDC_CHECK3, m_HadBackground);
}

BEGIN_MESSAGE_MAP(CFSDIndexerDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER ( )
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CFSDIndexerDlg::OnOpenContentXML)
	ON_BN_CLICKED(IDC_BUTTON5, &CFSDIndexerDlg::OnSaveContentXML)
	ON_LBN_SELCHANGE(IDC_LIST1, &CFSDIndexerDlg::OnLbnSelchangeList1)
	ON_EN_CHANGE(IDC_EDIT4, &CFSDIndexerDlg::OnTitleChange)
	ON_BN_CLICKED(IDC_BUTTON4, &CFSDIndexerDlg::OnDataForCurrent)
	ON_BN_CLICKED(IDC_BUTTON6, &CFSDIndexerDlg::OnDataForAll)
	ON_BN_CLICKED(IDCANCEL, &CFSDIndexerDlg::OnBnClickedCancel)
	ON_EN_CHANGE(IDC_EDIT3, &CFSDIndexerDlg::OnEnChangeEdit3)
	ON_EN_CHANGE(IDC_EDIT5, &CFSDIndexerDlg::OnEnChangeEdit5)
	ON_BN_CLICKED(IDC_BUTTON3, &CFSDIndexerDlg::OnViewIcon)
	ON_BN_CLICKED(IDC_BUTTON9, &CFSDIndexerDlg::OnViewBoxArt)
	ON_BN_CLICKED(IDC_BUTTON11, &CFSDIndexerDlg::OnViewScreenshot)
	ON_BN_CLICKED(IDC_RADIO1, &CFSDIndexerDlg::OnChangeViewInc)
	ON_BN_CLICKED(IDC_RADIO2, &CFSDIndexerDlg::OnChangeViewInc2)
	ON_BN_CLICKED(IDC_BUTTON14, &CFSDIndexerDlg::OnRemoveBoxArt)
	ON_BN_CLICKED(IDC_BUTTON13, &CFSDIndexerDlg::OnDelIcon)
	ON_BN_CLICKED(IDC_BUTTON12, &CFSDIndexerDlg::OnClearScreenshots)
	ON_BN_CLICKED(IDC_BUTTON8, &CFSDIndexerDlg::OnAddBoxart)
	ON_BN_CLICKED(IDC_BUTTON7, &CFSDIndexerDlg::OnAddIcon)
	ON_BN_CLICKED(IDC_BUTTON10, &CFSDIndexerDlg::OnAddScreenshot)
	ON_CBN_SELCHANGE(IDC_COMBO2, &CFSDIndexerDlg::OnChangeType)
	ON_BN_CLICKED(IDC_BUTTON15, &CFSDIndexerDlg::OnAddBackground)
	ON_BN_CLICKED(IDC_BUTTON16, &CFSDIndexerDlg::OnViewBackground)
	ON_BN_CLICKED(IDC_BUTTON17, &CFSDIndexerDlg::OnRemoveBackground)
END_MESSAGE_MAP()


// CFSDIndexerDlg message handlers

BOOL CFSDIndexerDlg::OnInitDialog()
{
	Changed = false;
	UpdateSel = true;
	UpdateName = true;

	CurSel = -1;
	CurType = -1;

	WSADATA wsaData;
    int iResult = WSAStartup(MAKEWORD(2,2), &wsaData);
    if (iResult != 0) {
        printf("WSAStartup failed: %d\n", iResult);
    }

	CDialog::OnInitDialog();

	pd.Create(IDD_PROGRESS,this);

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	InitOKChars();
	// TODO: Add extra initialization here

	WIN32_FIND_DATA findFileData;
	memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
	wstring searchcmd = L"cache\\temp\\*.*";
	HANDLE hFind = FindFirstFile(searchcmd.c_str(), &findFileData);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do {
			wstring file = wstring(L"cache\\temp\\") + findFileData.cFileName;
			_wunlink(file.c_str());
		} while (FindNextFile(hFind, &findFileData));
		FindClose(hFind);
	}

	INT_PTR nRet = -1;

	nRet = opt.DoModal();

	if (nRet == IDOK)
	{
		LoadContent();
	} else {
		PostQuitMessage(0);
	}

	m_Type.ResetContent();
	m_Type.AddString(L"All Games");
	m_Type.AddString(L"XBox 360 Games");
	m_Type.AddString(L"XBLA Games");
	m_Type.AddString(L"Homebrew");
	m_Type.AddString(L"Emulators");
	m_Type.SetCurSel(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFSDIndexerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFSDIndexerDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFSDIndexerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CFSDIndexerDlg::LoadContent()
{
	// setup datapath to usb or ftp etc

	pd.ShowWindow(SW_SHOW);
	ProcessMessages();

	pd.m_CurrentTask.SetWindowText(L"Connecting to xbox");
	ProcessMessages();
	// open via ftp, validate settings
	if (!ch.ValidateConn(&opt))
	{
		PostQuitMessage(0);
		return;
	}

	pd.m_CurrentTask.SetWindowText(L"Loading Content");
	ProcessMessages();

	cl.LoadContentXML();
	cl.BuildGenreList();

	UpdateData(true);
	SAFE_DELETE(items);
	items = cl.GetItems(m_ShowOnlyIncomplete,-1);

	m_GameList.ResetContent();
	for (int i = 0 ; i < items->nItems ; i++)
	{
		m_GameList.InsertString(i,items->pItems[i]->title.c_str());
	}
	m_GameList.SetCurSel(0);
	SelItem(0);

	SetTimer(1,100,NULL);
	//pd.ShowWindow(SW_HIDE);
	//ProcessMessages();

	/*SetWindowPos(&wndTop,0,0,0,0,SWP_NOSIZE);
	ProcessMessages();
	ShowWindow(SW_SHOW);
	ProcessMessages();*/
}

void CFSDIndexerDlg::OnTimer(UINT TimerVal) 
{
	if (TimerVal == 1)
	{
		pd.ShowWindow(SW_HIDE);
		ProcessMessages();
		KillTimer(1);
	}

	// Call base class handler.
	CDialog::OnTimer(TimerVal);
}

void CFSDIndexerDlg::OnOpenContentXML()
{
	INT_PTR nRet = -1;

	nRet = opt.DoModal();

	if (nRet == IDOK)
	{
		LoadContent();
	}
}

void CFSDIndexerDlg::OnSaveContentXML()
{
	cl.SaveContentList();
	Changed = false;
}

void CFSDIndexerDlg::SelItem(int NewSel)
{

	CurSel = NewSel;

	if (CurSel < 0 || CurSel >= items->nItems)
		return;

	ContentItem * item = items->pItems[NewSel];
	GameTitle.SetWindowText(item->title.c_str());
	m_Desc.SetWindowText(item->desc.c_str());
	wstring genres;
	vector<wstring>::iterator itr;
	for (itr = item->genres.begin();  itr != item->genres.end() ; itr++)
	{
		genres.append(*itr);
		genres.append(L", ");
	}
	genres = genres.substr(0,genres.size()-2);
	m_Genres.SetWindowText(genres.c_str());

	m_Manuf.SetWindowText(item->manuf.c_str());
	m_Path.SetWindowText(item->path.c_str());

	if (item->i_BoxArt)
	{
		m_HasBoxart.SetCheck(BST_CHECKED);
	} else {
		m_HasBoxart.SetCheck(BST_UNCHECKED);
	}

	if (item->i_Background)
	{
		m_HadBackground.SetCheck(BST_CHECKED);
	} else {
		m_HadBackground.SetCheck(BST_UNCHECKED);
	}

	if (item->i_Icon)
	{
		m_HasIcon.SetCheck(BST_CHECKED);
	} else {
		m_HasIcon.SetCheck(BST_UNCHECKED);
	}

	wstring ss = sprintfa(L"%d screenshots",item->i_SSCount);
	m_Screenshots.SetWindowText(ss.c_str());

	m_SSList.ResetContent();
	for (int i = 0 ; i < item->i_SSCount ; i++)
	{	
		m_SSList.AddString(sprintfa(L"ss-%d.jpg",i+1).c_str());
	}
	m_SSList.SetCurSel(0);

	m_Version.SetWindowText(sprintfa(L"%d",item->version).c_str());
	m_TitleID.SetWindowText(item->id.c_str());
	m_Disc.SetWindowText(sprintfa(L"%d of %d",item->discno,item->disccn).c_str());

	m_AltUrl.SetWindowText(item->imagefolder.c_str());
}

void CFSDIndexerDlg::OnLbnSelchangeList1()
{
	if (!UpdateSel)
		return;

	UpdateName = false;
	int NewSel = m_GameList.GetCurSel();
	if (NewSel < items->nItems)
	{
		SelItem(NewSel);
	}
	UpdateName = true;

}

void CFSDIndexerDlg::OnTitleChange()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;

	if (!UpdateName)
		return;

	UpdateSel = false;

	WCHAR buffer[255];
	GameTitle.GetWindowText(buffer,255);
	items->pItems[CurSel]->title = buffer;

	m_GameList.DeleteString(CurSel);
	m_GameList.InsertString(CurSel,buffer);
	m_GameList.SetCurSel(CurSel);

	Changed = true;
	UpdateSel = true;
}

void CFSDIndexerDlg::OnDataForCurrent()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;

	pd.Cancel = false;
	pd.ShowWindow(true);
	ContentItem * item = items->pItems[CurSel];
	pd.m_CurProgress.SetWindowText(item->title.c_str());
	ProcessMessages();

	GetData(CurSel);

	pd.ShowWindow(false);

	SelItem(CurSel);
}

void CFSDIndexerDlg::OnDataForAll()
{
	m_GameList.ResetContent();

	SAFE_DELETE(items);
	if (MessageBox(L"Scan incomplete games only?",0,MB_YESNO) == IDYES)
	{
		items = cl.GetItems(true);
	} else {
		items = cl.GetItems();
	}

	int count = 0;
	pd.Cancel = false;
	pd.ShowWindow(true);
	for (int i = 0 ; i < items->nItems ; i++)
	{
		ContentItem * item = items->pItems[i];

		pd.m_Progress.SetRange(0,items->nItems);
		pd.m_Progress.SetPos(i);

		pd.m_CurProgress.SetWindowText(item->title.c_str());

		ProcessMessages();

		if (!item->id.empty())
			GetData(i);

		if (count > 15 && Changed)
		{
			cl.SaveContentList();
			Changed = false;
			count = 0;
		}

		count++;

		if (pd.Cancel)
			break;
	}
	pd.ShowWindow(false);

	cl.SortAll();

	// reset view
	OnChangeViewInc();

	if (pd.Cancel)
	{
		MessageBox(L"Cancelled");
	} else {
		MessageBox(L"Done");
	}
}

void CFSDIndexerDlg::MarketplaceData(ContentItem * item, wstring& prodid, wstring& imageurl)
{

	wstring url = L"http://marketplace.xbox.com/en-US/games/media/66acd000-77fe-1000-9115-d802" + item->id + L"/";
	wstring cachefile = L"cache\\gameinfo\\" + item->imagefolder + L".txt";

	//printf("Getting game info for \"%s\"...",item->title.c_str());

	pd.m_CurrentTask.SetWindowText(L"Getting marketplace info");
	ProcessMessages();
	if (pd.Cancel)
		return;

	CHTTP http;
	string result;
	if (FileExists(cachefile))
	{
		FileToStringA(result,cachefile);
		wprintf(L"from cache\n");
	} else {
		http.Get(wstrtostr(url),result);
		StringToFileA(result,cachefile);
		wprintf(L"done\n");
	}

	//game.path = path;
	//game.filename = "default.xex";

	vector <string> Lines;
	vector <string>::iterator itr;

	pd.m_CurrentTask.SetWindowText(L"Processing marketplace info");
	ProcessMessages();

	if (result.size() > 0)
	{
		//TokenizeA(result,Lines,"</div>");

		//for (itr = Lines.begin() ; itr != Lines.end() ; itr++)
		{
			string Line = result;//(*itr);

			if (Line.find("<title>") != Line.npos)
			{
				string title = Line.substr(Line.find("lace | ") + 7);
				title = title.substr(0,title.find("<"));
				item->title = DecodeHtml(title);
			}

			if (Line.find("<div class=\"DescriptionText\">") != Line.npos)
			{
				string desc = Line.substr(Line.find("<div class=\"DescriptionText\">") + 29);
				desc = desc.substr(0,desc.find("<"));
				item->desc = DecodeHtml(desc);
			}

			if (Line.find("ctl00_MainContent_defaultGameDetail_gameMetaData") != Line.npos)
			{
				vector <string> bits;
				TokenizeA(Line,bits,"<");
				vector <string>::iterator it2;

				item->genres.clear();

				for (it2 = bits.begin() ; it2 != bits.end() ; it2++)
				{
					string Line2 = (*it2);

					if (Line2 == "strong>Genre:")
					{	
						it2++;
						it2++;
						Line2 = (*it2);
						while (Line2.substr(0,5) == "a hre")
						{
							wstring genre = DecodeHtml(Line2.substr(Line2.find(">")+1));
							item->genres.push_back(genre);
							it2++;
							it2++;
							Line2 = (*it2);
						}
					}
				}							
			}
			if (Line.find("<img class=\"GamePoster\" src=\"") != Line.npos)
			{
				string temp = Line.substr(Line.find("<img class=\"GamePoster\" src=\"") + 29);
				temp = temp.substr(0,temp.find("\""));
				imageurl = strtowstr(temp);
			}

			if (Line.find("Developer:") != Line.npos)
			{
				string remain = Line.substr(Line.find("Developer:") + 10);
				remain = remain.substr(remain.find(">")+1);
				remain = remain.substr(0,remain.find("<"));
				item->manuf = strtowstr(remain);
			}
			if (Line.find("productId=") != Line.npos)
			{
				string remain = Line.substr(Line.find("productId=") + 10);
				remain = remain.substr(0,remain.find("&"));
				prodid = strtowstr(remain);
			}
		}
	}

}

wstring XBoxcomGenre(wstring ingenre)
{
	if (ingenre == L"Action")
		return L"Action & Adventure";

	if (ingenre == L"Adventure")
		return L"Action & Adventure";

	if (ingenre == L"Survival Horror")
		return L"Action & Adventure";

	if (ingenre == L"Racing")
		return L"Racing & Flying";

	if (ingenre == L"Flying")
		return L"Racing & Flying";

	if (ingenre == L"Strategy")
		return L"Strategy & Simulation";

	if (ingenre == L"Sports")
		return L"Sports & Recreation";

	if (ingenre == L"Platform")
		return L"Platformer";

	if (ingenre == L"Trivia")
		return L"Puzzle & Trivia";

	return ingenre;
}

void CFSDIndexerDlg::XBoxcom(ContentItem * item, wstring url, wstring& prodid, wstring& imageurl)
{
	wstring cachefile = L"cache\\xboxcom\\" + item->imagefolder + L".txt";

	//printf("Getting game info for \"%s\"...",item->title.c_str());

	pd.m_CurrentTask.SetWindowText(L"Getting xbox.com info");
	ProcessMessages();
	if (pd.Cancel)
		return;

	CHTTP http;
	string result;
	if (FileExists(cachefile))
	{
		FileToStringA(result,cachefile);
		wprintf(L"from cache\n");
	} else {
		http.Get(wstrtostr(url),result);
		StringToFileA(result,cachefile);
		wprintf(L"done\n");
	}

	//game.path = path;
	//game.filename = "default.xex";

	vector<string> Lines;
	vector <string>::iterator itr;

	pd.m_CurrentTask.SetWindowText(L"Processing xbox.com info");
	ProcessMessages();

	if (result.size() > 0)
	{
		TokenizeA(result,Lines,"\n");

		for (itr = Lines.begin() ; itr != Lines.end() ; itr++)
		{
			string Line = (*itr);

			if (Line.find("<title>") != Line.npos)
			{
				string title = Line.substr(Line.find(" | ") + 2);
				if (title.find(" | ") != title.npos)
					title = title.substr(title.find(" | ") + 2);
				title = title.substr(0,title.find("-"));
				title = TrimA(title);
				if (title.find("<") != title.npos)
					title = title.substr(0,title.find("<"));
				item->title = DecodeHtml(title);
			}

			if (Line.find("<meta name=\"description\"") != Line.npos)
			{
				string desc = Line.substr(Line.find("<meta name=\"description\"") + 29);
				desc = desc.substr(desc.find("\"")+1);
				desc = desc.substr(0,desc.find("\""));
				item->desc = DecodeHtml(desc);
			}

			if (Line.find("Genre:") != Line.npos)
			{
				string remain = Line.substr(Line.find("Genre:") + 6);
				remain = remain.substr(remain.find(">")+1);
				while (remain.substr(0,1) == "<")
					remain = remain.substr(remain.find(">")+1);
				remain = remain.substr(0,remain.find("<"));
				item->genres.clear();
				item->genres.push_back(XBoxcomGenre(strtowstr(remain)));
			}

			/*if (Line.find("ctl00_MainContent_defaultGameDetail_gameMetaData") != Line.npos)
			{
				vector <string> bits;
				Tokenize(Line,bits,"<");
				vector <string>::iterator it2;

				item->genres.clear();

				for (it2 = bits.begin() ; it2 != bits.end() ; it2++)
				{
					string Line2 = (*it2);

					if (Line2 == "strong>Genre:")
					{	
						it2++;
						it2++;
						Line2 = (*it2);
						while (Line2.substr(0,5) == "a hre")
						{
							string genre = DecodeHtml(Line2.substr(Line2.find(">")+1));
							item->genres.push_back(genre);
							it2++;
							it2++;
							Line2 = (*it2);
						}
					}
				}							
			}*/
			/*if (Line.find("<img class=\"GamePoster\" src=\"") != Line.npos)
			{
				imageurl = Line.substr(Line.find("<img class=\"GamePoster\" src=\"") + 29);
				imageurl = imageurl.substr(0,imageurl.find("\""));
			}*/

			if (Line.find("Developer:") != Line.npos)
			{
				string remain = Line.substr(Line.find("Developer:") + 10);
				remain = remain.substr(remain.find(">")+1);
				while (remain.substr(0,1) == "<")
					remain = remain.substr(remain.find(">")+1);
				remain = remain.substr(0,remain.find("<"));
				item->manuf = strtowstr(remain);
			}
			if (Line.find("productId=") != Line.npos)
			{
				string remain = Line.substr(Line.find("productId=") + 10);
				remain = remain.substr(0,remain.find("&"));
				prodid = strtowstr(remain);
			}
		}
	}

}


void CFSDIndexerDlg::InitOKChars()
{
	memset(&OKChars,0,256);
	for (char i = 'a' ; i <= 'z' ; i++)
		OKChars[i] = 1;
	for (char i = 'A' ; i <= 'Z' ; i++)
		OKChars[i] = 1;
	for (char i = '0' ; i <= '9' ; i++)
		OKChars[i] = 1;
	OKChars[','] = 1;
	OKChars['.'] = 1;
	OKChars['-'] = 1;
	OKChars['_'] = 1;
	OKChars[' '] = 1;
	OKChars['+'] = 1;
	OKChars['='] = 1;
	OKChars['('] = 1;
	OKChars[')'] = 1;
	OKChars['{'] = 1;
	OKChars['}'] = 1;
	OKChars[']'] = 1;
	OKChars['['] = 1;
	OKChars['!'] = 1;
	OKChars['?'] = 1;
	OKChars['<'] = 1;
	OKChars['>'] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
	OKChars[(unsigned char)''] = 1;
}

wstring CFSDIndexerDlg::StripBadChars(wstring in)
{
	/*char out[10000];
	memset(out,0,10000);
	const char * inc = in.c_str();
	int res = 0;
	for (int i = 0 ; i < in.size() ; i++)
	{
		char tc = inc[i];
		if (OKChars[tc] == 1)
		{
			out[res++] = tc;
		}
	}
	out[res] = 0;
	string sout = out;*/
	return in;
}

void CFSDIndexerDlg::GetData(int ToGet)
{
	if (pd.Cancel)
		return;


	if (ToGet < 0 || ToGet >= items->nItems)
		return;

	Changed = true;

	ContentItem * item = items->pItems[ToGet];

	if (!FileExistsA("cache"))
		_mkdir("cache");
	if (!FileExistsA("cache\\gameinfo"))
		_mkdir("cache\\gameinfo");
	if (!FileExistsA("cache\\screenshots"))
		_mkdir("cache\\screenshots");
	if (!FileExistsA("cache\\xboxcom"))
		_mkdir("cache\\xboxcom");

	ch.Mkdir(datapath + L"\\artwork\\" + item->imagefolder);

	wstring prodid;
	wstring imageurl;

	AltInfo* ai = NULL;
	wstring tid = make_lowercase(item->id);
	map<wstring,AltInfo*>::iterator itr;
	itr = cl.AltInfos.find(tid);
	if (itr != cl.AltInfos.end())
	{
		ai = (*itr).second;
	}

	// if ai version is > 0, only match specific version
	if (ai && ai->Version > 0)
		if (item->version != ai->Version)
			ai = NULL;
	
	if (ai && !ai->AltUrl.empty())
	{
		XBoxcom(item,ai->AltUrl,prodid,imageurl);
	} else {
		MarketplaceData(item,prodid,imageurl);
	}

	if (ai)
	{
		if (!ai->Title.empty())
			item->title = ai->Title;
		if (!ai->Desc.empty())
			item->desc = ai->Desc;
		if (!ai->Manuf.empty())
			item->manuf = ai->Manuf;
		if (ai->Genres.size() > 0)
		{
			item->genres.clear();
			vector<wstring>::iterator gi;
			for (gi = ai->Genres.begin() ; gi != ai->Genres.end() ; gi++)
				item->genres.push_back(*gi);
		}
	}


	ProcessMessages();
	if (pd.Cancel)
		return;

	if (!item->i_BoxArt)
	{
		if (ai && !ai->BoxArt.empty())
		{ 
			if (GetBoxart(item->id,ai->BoxArt,datapath + L"\\artwork\\" + item->imagefolder + L"\\boxart.jpg",false))
				item->i_BoxArt = true;		
		} else {
			if (GetBoxart(item->id,imageurl,datapath + L"\\artwork\\" + item->imagefolder + L"\\boxart.jpg"))
				item->i_BoxArt = true;
		}
	}

	if (item->disccn > 1)
	{
		item->title = item->title + sprintfa(L" - Disc %d",item->discno);
	}

	item->title = StripBadChars(item->title);
	item->desc = StripBadChars(item->desc);
	item->manuf = StripBadChars(item->manuf);


	ProcessMessages();
	if (pd.Cancel)
		return;

	if (!item->i_Icon)
	{
		GetMissingIcon(item);
	}

	ProcessMessages();
	if (pd.Cancel)
		return;

	if (item->i_SSCount == 0)
	{
		if (ai && ai->Screenshots.size() > 0)
		{
			GetScreenshotsAlt(item,ai);
		} else if (!prodid.empty()) {
			GetScreenshots(item,prodid);
		}
	}

	if (item->i_Background == false)
	{
		if (ai && !ai->Background.empty())
		{ 
			if (GetBoxart(item->id,ai->Background,datapath + L"\\artwork\\" + item->imagefolder + L"\\background.jpg",false,true))
				item->i_Background = true;		
		} else {
			if (GetBoxart(item->id,L"",datapath + L"\\artwork\\" + item->imagefolder + L"\\background.jpg",true,true))
				item->i_Background = true;
		}
	}
}

void CFSDIndexerDlg::GetScreenshotsAlt(ContentItem * item, AltInfo* ai)
{
	pd.m_CurrentTask.SetWindowText(L"Getting Screenshot list");
	ProcessMessages();
	if (pd.Cancel)
		return;

	int sscount = ai->Screenshots.size();
	int ssno = 1;

	vector<wstring>::iterator itr;
	for (itr = ai->Screenshots.begin() ; itr != ai->Screenshots.end() ; itr++)
	{
		wstring temp = sprintfa(L"Getting screenshot %d of %d",ssno,sscount);
		pd.m_CurrentTask.SetWindowText(temp.c_str());
		ProcessMessages();
		if (pd.Cancel)
			return;

		wstring imageurl = (*itr);
		CHTTP http;
		int length = 0;
		wstring destfile = datapath + L"\\artwork\\" + item->imagefolder + sprintfa(L"\\ss-%d.jpg",ssno);
		if (!ch._FileExists(destfile))
		{
			char * image = http.GetBinary(wstrtostr(imageurl),length);

			if (length > 1000)
			{
				FILE * fp = 0;
				ch.WriteFile(&fp,destfile);
				if (fp)
				{
					fwrite(image,1,length,fp);
					ch.CloseFile(fp);
					item->i_SSCount++;
					ssno++;
				}
			}
		} else {
			item->i_SSCount++;
			ssno++;
		}
	}
}

void CFSDIndexerDlg::GetScreenshots(ContentItem * item, wstring prodid)
{
	pd.m_CurrentTask.SetWindowText(L"Getting Screenshot list");
	ProcessMessages();
	if (pd.Cancel)
		return;

	wstring url = L"http://www.xbox.com/en-US/games/viewerxml.aspx?productId=" + prodid;

	wstring cachefile = L"cache\\screenshots\\" + item->imagefolder + L".txt";

	CHTTP http;
	string result;
	if (FileExists(cachefile))
	{
		FileToStringA(result,cachefile);
		printf("from cache\n");
	} else {
		http.Get(wstrtostr(url),result);
		StringToFileA(result,cachefile);
		printf("done\n");
	}

	XMLReader * xml = LoadConfigFile(cachefile);

	int ssno = 1;
	int sscount = 0;
	while (xml && xml->read())
	{
		if (StartAttribute(xml,L"element"))
		{
			sscount++;
		}
	}
	xml->restart();

	while (xml && xml->read())
	{
		if (StartAttribute(xml,L"element"))
		{
			wstring temp = sprintfa(L"Getting screenshot %d of %d",ssno,sscount);
			pd.m_CurrentTask.SetWindowText(temp.c_str());
			ProcessMessages();
			if (pd.Cancel)
				return;

			wstring imageurl = wstring(L"http://www.xbox.com") + wstring(xml->getAttributeValue(L"file"));
			CHTTP http;
			int length = 0;
			wstring destfile = datapath + L"\\artwork\\" + item->imagefolder + sprintfa(L"\\ss-%d.jpg",ssno);
			if (!ch._FileExists(destfile))
			{
				char * image = http.GetBinary(wstrtostr(imageurl),length);

				if (length > 1000)
				{
					FILE * fp = 0;
					ch.WriteFile(&fp,destfile);
					if (fp)
					{
						fwrite(image,1,length,fp);
						ch.CloseFile(fp);
						item->i_SSCount++;
						ssno++;
					}
				}
			} else {
				item->i_SSCount++;
				ssno++;
			}

		}
	}

	FreeXML(xml);
}

void CFSDIndexerDlg::GetMissingIcon(ContentItem * item)
{
	pd.m_CurrentTask.SetWindowText(L"Getting Icon");
	ProcessMessages();
	if (pd.Cancel)
		return;

	wstring url = L"http://www.testpad2.org/x360/icons/" + make_uppercase(item->id) + L".png";
	wstring destfile = datapath + L"\\artwork\\" + item->imagefolder + L"\\icon.png";

	if (ch._FileExists(destfile))
	{
		item->i_Icon = true;
		return;
	}

	CHTTP http;
	int length = 0;
	char * image = http.GetBinary(wstrtostr(url),length);

	if (length > 1000)
	{
		FILE * fp = 0;
		ch.WriteFile(&fp,destfile);
		//fopen_s(&fp,destfile.c_str(),"wb");
		if (fp)
		{
			fwrite(image,1,length,fp);
			//fclose(fp);
			ch.CloseFile(fp);
			item->i_Icon = true;
		}

		//JPG2PNG(boxartfile,boxartfilepng);
	}
}


bool CFSDIndexerDlg::GetBoxart(wstring id, wstring imageurl,wstring destfile,bool CheckDefault,bool Background)
{

	bool gotimage = false;
	wstring origurl = imageurl;
	if (Background)
	{
		imageurl = L"http://tiles.xbox.com/consoleAssets/" + id + L"/en-US/background.jpg";
	} else {
		imageurl = L"http://tiles.xbox.com/consoleAssets/" + id + L"/en-US/largeboxart.jpg";
	}

	if (!ch._FileExists(destfile))
	{
		if (Background)
		{
			pd.m_CurrentTask.SetWindowText(L"Getting Background");
		} else {
			pd.m_CurrentTask.SetWindowText(L"Getting Box Art");
		}
		ProcessMessages();

		wstring folder = destfile.substr(0,destfile.rfind(L"\\"));

		//if (!FileExists(folder))
		//	_mkdir(folder.c_str());

		if (CheckDefault && !imageurl.empty())
		{
			CHTTP http;
			int length = 0;
			char * image = http.GetBinary(imageurl,length);

			if (length > 1000)
			{
				FILE * fp = 0;
				ch.WriteFile(&fp,destfile);
				//fopen_s(&fp,destfile.c_str(),"wb");
				if (fp)
				{
					fwrite(image,1,length,fp);
					ch.CloseFile(fp);
					//fclose(fp);
					gotimage = true;
				}
			}
			SAFE_DELETE(image);
		}

		if (!gotimage)
		{
			if (!origurl.empty())
			{
				CHTTP http;
				int length = 0;
				char * image2 = http.GetBinary(origurl,length);

				if (length > 500)
				{
					FILE * fp = 0;
					ch.WriteFile(&fp,destfile);
					//fopen_s(&fp,destfile.c_str(),"wb");
					if (fp)
					{
						fwrite(image2,1,length,fp);
						ch.CloseFile(fp);
						gotimage = true;
					}

					//JPG2PNG(boxartfile,boxartfilepng);
				}
				SAFE_DELETE(image2);
			}
		}

	} else {
		gotimage = true;
	}

	return gotimage;

}

void CFSDIndexerDlg::OnBnClickedCancel()
{
	if (Changed)
	{
		if (MessageBox(L"Data changed, do you want to save it?",L"Save changes?",MB_YESNO) == IDOK)
		{
			cl.SaveContentList();
			Changed = false;
		}
	}
	if (MessageBox(L"Do you wish to reboot your xbox?",0,MB_YESNO) == IDYES)
	{

		sockaddr_in service;
		service.sin_family = AF_INET;
		memset(service.sin_zero, 0, sizeof(service.sin_zero));
		service.sin_addr.s_addr = inet_addr(wstrtostr(opt.ftphost).c_str());
		service.sin_port = htons(opt.m_Port);

		SOCKET s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
		
		if (s == INVALID_SOCKET)
		{
			printf("Error creating socket\n");
			OnCancel();
			return;
		}

		if (connect(s,(const sockaddr*)&service,sizeof(sockaddr_in)) == SOCKET_ERROR)
		{
			printf("Unable to connect\n");
			OnCancel();
			return;
		}

		char temp[1024];
		strcpy(temp,"REBO\r\n");

		send(s,temp,sizeof(temp),0);
		recv(s,temp,1024,0);
		closesocket(s);
		
		// do reboot! what XEX though?
		int k = 0;
	}
	// TODO: Add your control notification handler code here
	OnCancel();
}

void CFSDIndexerDlg::OnEnChangeEdit3()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;

	if (!UpdateName)
		return;

	WCHAR buffer[255];
	m_Manuf.GetWindowText(buffer,255);
	items->pItems[CurSel]->manuf = buffer;
	Changed = true;
}

void CFSDIndexerDlg::OnEnChangeEdit5()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;

	if (!UpdateName)
		return;

	WCHAR buffer[8000];
	m_Desc.GetWindowText(buffer,8000);
	items->pItems[CurSel]->desc = buffer;
	Changed = true;
}

void CFSDIndexerDlg::DownloadAndOpen(wstring file)
{
	file = ch.DownloadFile(file);

	if (!FileExists(file))
	{
		MessageBox(L"Error getting image file");
		return;
	}

	SHELLEXECUTEINFO si;
	memset(&si,sizeof(si),0);
	si.cbSize = sizeof(SHELLEXECUTEINFO);
	si.fMask = SEE_MASK_NOCLOSEPROCESS | SEE_MASK_NOZONECHECKS;
	WCHAR temp[1024];
	_wgetcwd(temp,1024);
	wstring filename = file.substr(file.rfind(L"\\")+1);
	wstring folder = file.substr(0,file.rfind(L"\\")+1);
	if (folder.find(L":") == folder.npos)
	{
		folder = wstring(temp) + wstring(L"\\") + folder;
	}
	si.lpVerb = L"open";
	si.lpFile = filename.c_str();
	si.lpDirectory = folder.c_str();
	si.lpParameters = L"";
	si.nShow = SW_SHOWDEFAULT;
	si.hInstApp = 0;
	si.lpIDList = 0;

	ShellExecuteEx(&si);
}

void CFSDIndexerDlg::OnViewIcon()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	wstring file = datapath + L"artwork\\" + item->imagefolder + L"\\icon.png";

	DownloadAndOpen(file);
}

void CFSDIndexerDlg::OnViewBoxArt()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	wstring file = datapath + L"artwork\\" + item->imagefolder + L"\\boxart.jpg";

	DownloadAndOpen(file);
}

void CFSDIndexerDlg::OnViewScreenshot()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	wstring ssfile = sprintfa(L"ss-%d.jpg",m_SSList.GetCurSel()+1);

	wstring file = datapath + L"artwork\\" + item->imagefolder + L"\\" + ssfile;

	DownloadAndOpen(file);
}

void CFSDIndexerDlg::OnChangeViewInc()
{
	UpdateData(true);
	SAFE_DELETE(items);
	items = cl.GetItems(m_ShowOnlyIncomplete,CurType);

	m_GameList.ResetContent();
	for (int i = 0 ; i < items->nItems ; i++)
	{
		m_GameList.InsertString(i,items->pItems[i]->title.c_str());
	}
	m_GameList.SetCurSel(0);
	SelItem(0);
}

void CFSDIndexerDlg::OnChangeViewInc2()
{
	OnChangeViewInc();
}

void CFSDIndexerDlg::OnRemoveBoxArt()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	wstring file = datapath + L"artwork\\" + item->imagefolder + L"\\boxart.jpg";

	ch.DeleteFile(file);

	item->i_BoxArt = false;

	SelItem(CurSel);
}

void CFSDIndexerDlg::OnDelIcon()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	wstring file = datapath + L"artwork\\" + item->imagefolder + L"\\icon.png";

	ch.DeleteFile(file);

	item->i_Icon = false;

	SelItem(CurSel);
}

void CFSDIndexerDlg::OnClearScreenshots()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	for (int i = 1 ; i <= item->i_SSCount ; i++)
	{
		wstring file = datapath + L"artwork\\" + item->imagefolder + sprintfa(L"\\ss-%d.jpg",i);
		ch.DeleteFile(file);
	}

	item->i_SSCount = 0;

	SelItem(CurSel);
}

void CFSDIndexerDlg::OnAddBoxart()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	static WCHAR BASED_CODE szFilter[] = L"JPG Files (*.jpg)|*.jpg|All Files (*.*)|*.*||";
	CFileDialog FileDlg(true,0,0,4|2,szFilter);
	if (FileDlg.DoModal() == IDOK)
	{
		wstring destfile = datapath + L"\\artwork\\" + item->imagefolder + L"\\boxart.jpg";
		wstring sourcefile = FileDlg.GetPathName();
		if (ch.UplodaFile(sourcefile,destfile))
		{
			item->i_BoxArt = 1;
			Changed = true;
		}
	}

	SelItem(CurSel);
}

void CFSDIndexerDlg::OnAddIcon()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	static WCHAR BASED_CODE szFilter[] = L"PNG Files (*.png)|*.png|All Files (*.*)|*.*||";
	CFileDialog FileDlg(true,0,0,4|2,szFilter);
	if (FileDlg.DoModal() == IDOK)
	{
		wstring destfile = datapath + L"\\artwork\\" + item->imagefolder + L"\\icon.png";
		wstring sourcefile = FileDlg.GetPathName();
		if (ch.UplodaFile(sourcefile,destfile))
		{
			item->i_Icon = 1;
			Changed = true;
		}
	}

	SelItem(CurSel);
}

void CFSDIndexerDlg::OnAddScreenshot()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	static WCHAR BASED_CODE szFilter[] = L"JPG Files (*.jpg)|*.jpg|All Files (*.*)|*.*||";
	CFileDialog FileDlg(true,0,0,4|2,szFilter);
	if (FileDlg.DoModal() == IDOK)
	{
		int ssno = item->i_SSCount+1;

		wstring destfile = datapath + L"\\artwork\\" + item->imagefolder + sprintfa(L"\\ss-%d.jpg",ssno);
		wstring sourcefile = FileDlg.GetPathName();
		if (ch.UplodaFile(sourcefile,destfile))
		{
			item->i_SSCount = ssno;
			Changed = true;
		}
	}

	SelItem(CurSel);
}

void CFSDIndexerDlg::OnChangeType()
{
	/*0 m_Type.AddString("All Games");
	1 m_Type.AddString("XBox 360 Games");
	2 m_Type.AddString("XBLA Games");
	3 m_Type.AddString("Homebrew");
	4 m_Type.AddString("Emulators");*/

	int NewType = m_Type.GetCurSel();
	if (NewType == 0)
		CurType = -1;
	if (NewType == 1)
		CurType = 1;
	if (NewType == 2)
		CurType = 0;
	if (NewType == 3)
		CurType = 3;
	if (NewType == 4)
		CurType = 4;
	OnChangeViewInc();
}

void CFSDIndexerDlg::OnAddBackground()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	static WCHAR BASED_CODE szFilter[] = L"JPG Files (*.jpg)|*.jpg|All Files (*.*)|*.*||";
	CFileDialog FileDlg(true,0,0,4|2,szFilter);
	if (FileDlg.DoModal() == IDOK)
	{
		wstring destfile = datapath + L"\\artwork\\" + item->imagefolder + L"\\background.jpg";
		wstring sourcefile = FileDlg.GetPathName();
		if (ch.UplodaFile(sourcefile,destfile))
		{
			item->i_Background = true;
			Changed = true;
		}
	}

	SelItem(CurSel);

}

void CFSDIndexerDlg::OnViewBackground()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	wstring file = datapath + L"artwork\\" + item->imagefolder + L"\\background.jpg";

	DownloadAndOpen(file);
}

void CFSDIndexerDlg::OnRemoveBackground()
{
	if (CurSel < 0 || CurSel >= items->nItems)
		return;
	ContentItem * item = items->pItems[CurSel];

	wstring file = datapath + L"artwork\\" + item->imagefolder + L"\\background.jpg";

	ch.DeleteFile(file);

	item->i_Background = false;

	SelItem(CurSel);
}
